/**
* \file: WaylandInputSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADIT/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_WAYLAND_INPUTSOURCE_H
#define AAUTO_WAYLAND_INPUTSOURCE_H

#include <aauto/util/shared_ptr.h>
#include <aauto/InputSource.h>
#include "aauto/AditInputSource.h"

namespace adit { namespace aauto {

class WaylandInputSourceImpl;

/** 
 * @brief WaylandInputSource provides Wayland specific input implementation.*/
class WaylandInputSource : public AditInputSource
{
public:
/**
 * @brief  Constructor of WaylandInputSource. 
 * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
 * @param  inMessageRouter  inMessageRouter is message router obtained from GalReceiver.
 */
    WaylandInputSource(uint8_t inSessionId, MessageRouter* inMessageRouter);
    virtual ~WaylandInputSource();
/**
 * @brief  Initialize the WaylandInputSource library and set configured parameters to the
 * wayland interface.
 * @return true if initialization succeeds. Otherwise false.
 **/
    bool init();
/**
 * @brief  Shutdown the WaylandInputSource library.
 * @return true if initialization succeeds. Otherwise false.
 */
    bool shutdown();
/**
 * @brief  Set the configuration for the wayland interface. Must be called before init(). 
 * @param  inKey        The key string for configuration (e.g. "wl-touch-type")
 *     - wl-touch-layer-id [mandatory]:Item is layer ID that is used in layer manager. 
 *     - wl-touch-surface-id [mandatory]:Item is surface ID that is used in layer manager. 
 *     - wl-touch-input-trigger-interval-usec [mandatory]:Interval time for touch detection. 
 *     - wl-touch-type [mandatory]:Selects the type of touch device. 
 *     -  ('1':Auto Type '2':Pointor Type '3':Single Touch Type '4':Multi Touch Type)
 *     - display-width [mandatory]:Maximum width of input device for layer manager. 
 *     - display-height [mandatory]:Maximum height of input device for layer manager. 
 * 
 * @param  inValue      The actual value for configuration (e.g. "800", "950") */

    void setConfigItem(string inKey, string inValue);

/**
 * @brief Register callback interface to receive input-related notifications.
 * See IAditInputSourceCallbacks for details.
 *
 * @param   inCallbacks object implementing the callback interface
 */
    void registerCallbacks(IAditInputSourceCallbacks* inCallbacks);

private:
   WaylandInputSourceImpl *impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_WAYLAND_INPUTSOURCE_H */
